#==============================================================================
#  Window_Actor_Menu_Skill
#------------------------------------------------------------------------------
# XLAN^[j[
# Copyright (C) 2005 fukuyama
#==============================================================================

module DQ
  
  class Window_Actor_Menu_Skill < Window_Actor_Menu_Base
    #----------------------------------------------------------------------------
    # 
    #----------------------------------------------------------------------------
    def initialize(parent,title)
      super(parent,title)
      
      # ʒu̐ݒ
      rect = parent.menu_rect(parent.index)
      self.x = parent.x + rect.x
      self.y = parent.y + rect.y
      
      # XLEBhE쐬
      @window_skill = Window_Skill.new(self)
      
      initialize_skill_owner_status
      refresh_skill_owner_target_status
    end
    
    def select_actor
      skills = Skill_Facade.actor_normal_skills self.actor
      if skills.size == 0
        return
      end
      set_active_window(Window_Skill)
      @window_skill.index = 0
    end
    
    def change_actor
      @window_skill.refresh
      refresh_skill_owner_target_status
    end
    
    def update
      super
      if @_prev_sp != self.actor.sp
        refresh_skill_owner_target_status
      end
    end
    
    # 
    def initialize_skill_owner_status
      x = @window_skill.right
      y = @window_skill.top
      w = 640 - 16 - x
      h = Markup_New_Line.line_height * 2 + 32
      @window_skill_owner_status = Window_Markup_Text.new(x,y,w,h)
      @window_skill_owner_status.back_opacity = self.back_opacity
      
      # qEBhEɒǉ
      add_child @window_skill_owner_status
      @window_skill_owner_status.visible = true
    end
    
    # ĕ`
    def refresh_skill_owner_target_status
      target_actor = self.actor
      n = target_actor.sp
      m = target_actor.maxsp
      @_prev_sp = n
      color = '\C[n]'
      if n == 0
        color = '\C[ko]'
      elsif n < m / 4
        color = '\C[cs]'
      end
      n = sprintf("%4d",n)
      m = sprintf("%4d",m)
      text = ''
      text << "\\C[n]\\left[#{$data_system.words.sp}]#{$data_system.words.sp}\\n"
      text << "#{color}\\center_left[#{n} ]#{n}"
      text << "\\C[n]\\center_right[/ #{m}]/ #{m}"
      @window_skill_owner_status.set_text(text)
    end
  end
  
end
